using System;
using System.Linq;
using System.Collections.Generic;

class Program
{
    static bool NoMultiplicationOverflow(int a, int b)
    {
        unchecked
        {
            var result = a * b;
            return result / b == a;
        }
    }

    static void Main()
    {
        var brojUpita = int.Parse(Console.ReadLine());
        var rezultati = new Queue<int>();
        var duplikati = new HashSet<int>();

        for (int i = 0; i < brojUpita; i++)
        {
            var preprekeIVojnici = Console.ReadLine().Split(' ');
            var brojPrepreka = int.Parse(preprekeIVojnici[0]);
            var vojnici = int.Parse(preprekeIVojnici[1]);

            var mnozenja = Console.ReadLine().Split(' ');
            var sabiranja = Console.ReadLine().Split(' ');
            var donjeGranice = Console.ReadLine().Split(' ');
            var gornjeGranice = Console.ReadLine().Split(' ');
            
            rezultati.Enqueue(vojnici);

            for (int j = 0; j < brojPrepreka; j++)
            {
                var zaMnozenje = int.Parse(mnozenja[j]);
                var zaSabiranje = int.Parse(sabiranja[j]);
                var zaDonju = int.Parse(donjeGranice[j]);
                var zaGornju = int.Parse(gornjeGranice[j]);
                var velicina = rezultati.Count;
                duplikati.Clear();

                for (int k = 0; k < velicina; k++)
                {
                    var trenutniVojnici = rezultati.Dequeue();
                    var zbir = trenutniVojnici + zaSabiranje;
                    if (zbir >= zaDonju && zbir <= zaGornju && duplikati.Add(zbir))
                    {
                        rezultati.Enqueue(zbir);
                    }

                    if (NoMultiplicationOverflow(trenutniVojnici, zaMnozenje))
                    {
                        var proizvod = trenutniVojnici * zaMnozenje;
                        if (proizvod >= zaDonju && proizvod <= zaGornju && duplikati.Add(proizvod))
                        {
                            rezultati.Enqueue(proizvod);
                        }
                    }
                }
            }

            if (rezultati.Count == 0)
            {
                Console.WriteLine("nemoguce");
            }
            else
            {
                var maks = int.MinValue;
                while(rezultati.Count > 0)
                {
                    maks = Math.Max(rezultati.Dequeue(), maks);
                }
                Console.WriteLine(maks);
            }
        }
    }
}